def migrate(cr, version):
    # Add threshold columns to product template
    cr.execute("""
        ALTER TABLE product_template 
        ADD COLUMN IF NOT EXISTS stock_card_low_threshold numeric DEFAULT 100.0;
        
        ALTER TABLE product_template 
        ADD COLUMN IF NOT EXISTS stock_card_normal_threshold numeric DEFAULT 500.0;
    """)
    
    # Copy existing warehouse thresholds to products if they exist
    cr.execute("""
        UPDATE product_template pt
        SET stock_card_low_threshold = sw.stock_card_low_threshold,
            stock_card_normal_threshold = sw.stock_card_normal_threshold
        FROM stock_warehouse sw
        WHERE sw.stock_card_low_threshold IS NOT NULL
        AND sw.stock_card_normal_threshold IS NOT NULL;
    """)
    
    # Drop columns from warehouse table
    cr.execute("""
        ALTER TABLE stock_warehouse 
        DROP COLUMN IF EXISTS stock_card_low_threshold,
        DROP COLUMN IF EXISTS stock_card_normal_threshold;
    """) 