# -*- coding: utf-8 -*-
from odoo import models
from datetime import datetime

class StockCardXlsx(models.AbstractModel):
    _name = 'report.sss_stock_card_report.stock_card_xlsx'
    _inherit = 'report.report_xlsx.abstract'
    _description = 'Stock Card Excel Report'

    def _get_report_name(self, wizard):
        return f'Stock Card Report - {datetime.now().strftime("%Y-%m-%d %H-%M-%S")}'

    def _get_report_columns(self, report):
        return {
            0: {'header': 'Date', 'field': 'date', 'width': 15},
            1: {'header': 'Reference', 'field': 'reference', 'width': 20},
            2: {'header': 'Quantity In', 'field': 'quantity_in', 'width': 15, 'type': 'number'},
            3: {'header': 'Quantity Out', 'field': 'quantity_out', 'width': 15, 'type': 'number'},
            4: {'header': 'Balance', 'field': 'balance', 'width': 15, 'type': 'number'},
        }

    def generate_xlsx_report(self, workbook, data, wizard):
        # Format definitions
        header_format = workbook.add_format({
            'bold': True,
            'align': 'center',
            'valign': 'vcenter',
            'fg_color': '#875A7B',
            'color': 'white',
            'border': 1,
        })

        date_format = workbook.add_format({
            'num_format': 'yyyy-mm-dd',
            'align': 'center',
        })

        number_format = workbook.add_format({
            'num_format': '#,##0.00',
            'align': 'right',
        })

        positive_number = workbook.add_format({
            'num_format': '#,##0.00',
            'align': 'right',
            'color': 'green',
        })

        negative_number = workbook.add_format({
            'num_format': '#,##0.00',
            'align': 'right',
            'color': 'red',
        })

        total_format = workbook.add_format({
            'bold': True,
            'num_format': '#,##0.00',
            'align': 'right',
            'fg_color': '#875A7B',
            'color': 'white',
            'border': 1,
        })

        # Get data
        lines = wizard._get_stock_card_lines()
        columns = self._get_report_columns(lines)

        # Create worksheet
        sheet = workbook.add_worksheet('Stock Card Report')

        # Set columns width
        for col, column in columns.items():
            sheet.set_column(col, col, column['width'])

        # Write headers
        for col, column in columns.items():
            sheet.write(0, col, column['header'], header_format)

        # Write data
        row = 1
        for line in lines:
            sheet.write(row, 0, line['date'], date_format)
            sheet.write(row, 1, line['reference'])
            sheet.write(row, 2, line['quantity_in'], positive_number if line['quantity_in'] else number_format)
            sheet.write(row, 3, line['quantity_out'], negative_number if line['quantity_out'] else number_format)
            sheet.write(row, 4, line['balance'], 
                      positive_number if line['balance'] >= 0 else negative_number)
            row += 1

        # Write totals
        sheet.write(row, 1, 'Total', header_format)
        sheet.write(row, 2, sum(line['quantity_in'] for line in lines), total_format)
        sheet.write(row, 3, sum(line['quantity_out'] for line in lines), total_format)
        sheet.write(row, 4, lines[-1]['balance'] if lines else 0, total_format)