/** @odoo-module */

import { registry } from "@web/core/registry";
import { download } from "@web/core/network/download";
import { useService } from "@web/core/utils/hooks";

const actionRegistry = registry.category("actions");

class StockCardExcelExport {
    setup() {
        this.orm = useService("orm");
        this.action = useService("action");
    }

    async exportToExcel(action) {
        const { headers, rows, filename, title } = action.data;
        
        // Create workbook data
        const workbook = {
            sheets: [{
                name: title,
                headers: headers,
                data: rows.map(row => [
                    row.date,
                    row.reference,
                    row.in,
                    row.out,
                    row.balance
                ])
            }]
        };

        // Download the Excel file
        await download({
            url: '/web/export/xlsx',
            data: {
                workbook: JSON.stringify(workbook),
                filename: filename,
            },
        });

        return { type: 'ir.actions.act_window_close' };
    }
}

actionRegistry.add('stock_card_excel_export', StockCardExcelExport);

export default StockCardExcelExport; 