# -*- coding: utf-8 -*-
# All Copyrights Reserved to Solid Super Solutions
from odoo import models, api, fields

class AccountMove(models.Model):
    _inherit = 'account.move'

    show_update_label = fields.Boolean(
        string='Show Update Label',
        compute='_compute_show_update_label',
        store=False
    )
    
    @api.depends('ref', 'journal_id')
    def _compute_show_update_label(self):
        for record in self:
            if record.move_type == 'entry' and record.journal_id.auto_fill_journal_item_name:
                lines_with_diff_name = record.line_ids.filtered(lambda l: l.name != record.ref)
                record.show_update_label = bool(lines_with_diff_name)
            else:
                record.show_update_label = False

    def action_update_labels(self):
        self.ensure_one()
        if (self.move_type == 'entry' and 
            self.journal_id.auto_fill_journal_item_name and 
            self.ref):
            self.line_ids.write({'name': self.ref})
        return True

    def _update_journal_items_name(self):
        self.ensure_one()
        if (self.move_type == 'entry' and 
            self.journal_id.auto_fill_journal_item_name and 
            self.ref):
            self.line_ids.write({'name': self.ref})