# Inherit Description Reference Module (Odoo 19)

<div align="center">

**نسخ المرجع تلقائياً إلى أسماء بنود القيود في Odoo 19**

[![License](https://img.shields.io/badge/license-LGPL--3-blue.svg)](LICENSE)
[![Version](https://img.shields.io/badge/version-19.0.1.0.0-green.svg)](__manifest__.py)
[![Odoo](https://img.shields.io/badge/odoo-19.0-blue.svg)](https://www.odoo.com)

</div>

---

## 📋 نظرة عامة | Overview

موديول **نسخ المرجع إلى الوصف** يبسط عملية إدخال القيود المحاسبية في Odoo من خلال نسخ قيمة حقل المرجع تلقائياً إلى حقل الاسم في بنود القيد المرتبطة. يمكن تكوين هذه الميزة لكل دفتر يومية أو على مستوى الشركة، مما يوفر مرونة كاملة في التحكم في السلوك.

The **Inherit Description Reference** module simplifies journal entry input in Odoo by automatically copying the reference field value to the name field in related journal items. This feature can be configured per journal or at the company level, providing complete flexibility in controlling the behavior.

---

## ✨ المميزات الرئيسية | Key Features

### 🔄 النسخ التلقائي | Automatic Copying
- **نسخ تلقائي**: نسخ قيمة المرجع تلقائياً إلى أسماء بنود القيود
- **قابل للتكوين**: يمكن تفعيله لكل دفتر يومية بشكل منفصل
- **تكوين على مستوى الشركة**: خيار لتطبيق الإعداد على مستوى الشركة

- **Automatic Copying**: Automatically copies reference value to journal item names
- **Configurable**: Can be enabled per journal separately
- **Company-Level Configuration**: Option to apply setting at company level

### 🎯 التحكم الذكي | Smart Control
- **زر تحديث**: زر "Update Labels" يظهر تلقائياً عندما تختلف أسماء البنود عن المرجع
- **تحديث بنقرة واحدة**: تحديث جميع أسماء البنود بنقرة واحدة
- **للقيود فقط**: يعمل فقط مع القيود (Journal Entries) وليس الفواتير

- **Update Button**: "Update Labels" button appears automatically when line names differ from reference
- **One-Click Update**: Update all line names with one click
- **Entries Only**: Works only with Journal Entries, not invoices

### 📊 واجهة المستخدم | User Interface
- **زر واضح**: زر "Update Labels" واضح في رأس القيد
- **ظهور تلقائي**: يظهر فقط عندما يكون التحديث مطلوباً
- **سهولة الاستخدام**: واجهة بسيطة وبديهية

- **Clear Button**: "Update Labels" button is clear in journal entry header
- **Auto-Appearance**: Only appears when update is needed
- **User-Friendly**: Simple and intuitive interface

---

## 🚀 التثبيت | Installation

### المتطلبات | Prerequisites
- Odoo 19.0 أو أحدث
- موديول `account` (المحاسبة) مثبت ومفعّل

- Odoo 19.0 or later
- `account` module installed and enabled

### خطوات التثبيت | Installation Steps

1. **انسخ الموديول** إلى مجلد الإضافات:
   ```bash
   cp -r sss_ref_desc /path/to/odoo/addons/
   ```

2. **حدّث قائمة التطبيقات** في Odoo:
   - اذهب إلى قائمة **Apps**
   - اضغط **Update Apps List**

3. **ثبّت الموديول**:
   - ابحث عن "Inherit Description Reference"
   - اضغط **Install**

---

## 📖 دليل الاستخدام | Usage Guide

### الإعداد الأولي | Initial Setup

#### تفعيل الميزة على مستوى الدفتر | Enabling at Journal Level

1. اذهب إلى **المحاسبة > الإعدادات > دفاتر اليومية**
2. افتح الدفتر الذي تريد تفعيل الميزة له
3. في نموذج الدفتر، ابحث عن حقل **"Auto-fill Journal Item Names"**
4. فعّل الخيار
5. احفظ الدفتر

#### تفعيل الميزة على مستوى الشركة | Enabling at Company Level

1. اذهب إلى **الإعدادات > الشركات > الشركات**
2. افتح الشركة التي تريد تكوينها
3. في نموذج الشركة، ابحث عن حقل **"Auto-fill Journal Item Names"**
4. فعّل الخيار
5. احفظ الشركة

### الاستخدام اليومي | Daily Usage

#### إنشاء قيد جديد | Creating a New Entry

**عندما تكون الميزة مفعّلة:**

1. اذهب إلى **المحاسبة > القيود > القيود**
2. أنشئ قيداً جديداً
3. اختر دفتر اليومية (يجب أن يكون "Auto-fill Journal Item Names" مفعّلاً)
4. أدخل **المرجع** (Reference)
5. أضف بنود القيد
6. **تلقائياً**: سيتم نسخ قيمة المرجع إلى حقل "Name" في جميع البنود

**مثال | Example:**
- المرجع: "Payment to Supplier ABC"
- البنود: سيتم نسخ "Payment to Supplier ABC" تلقائياً إلى حقل Name في كل بند

#### تحديث البنود الموجودة | Updating Existing Lines

إذا كانت أسماء البنود مختلفة عن المرجع:

1. افتح القيد
2. ستلاحظ ظهور زر **"Update Labels"** في رأس القيد
3. اضغط الزر
4. سيتم تحديث جميع أسماء البنود لتطابق المرجع

### حالات الاستخدام | Use Cases

#### حالة 1: قيود منتظمة
**السيناريو**: قيود شهرية منتظمة تحتاج إلى نفس الوصف

**الحل**: فعّل الميزة في دفتر اليومية، وستتم إضافة الوصف تلقائياً لكل قيد

#### حالة 2: تحديث القيود القديمة
**السيناريو**: قيود موجودة بأسماء مختلفة عن المرجع

**الحل**: استخدم زر "Update Labels" لتحديث جميع البنود دفعة واحدة

#### حالة 3: دفاتر يومية متعددة
**السيناريو**: بعض دفاتر اليومية تحتاج الميزة وبعضها لا

**الحل**: فعّل الميزة فقط في دفاتر اليومية المطلوبة

---

## 🛠️ التفاصيل التقنية | Technical Details

### هيكل الموديول | Module Structure

```
sss_ref_desc/
├── models/
│   ├── account_move.py          # نموذج القيد مع وظائف النسخ
│   ├── account_journal.py       # نموذج دفتر اليومية مع خيار التفعيل
│   └── res_company.py           # نموذج الشركة مع خيار التفعيل
├── views/
│   ├── account_move_views.xml   # واجهات القيد
│   ├── account_journal_views.xml # واجهات دفتر اليومية
│   └── res_company_views.xml    # واجهات الشركة
└── static/
    └── description/
        └── icon_ref_desc.png
```

### التوسعات على النماذج | Model Extensions

#### `account.move` (Extended)

**حقول جديدة | New Fields:**
- `show_update_label` (Boolean): يحدد ما إذا كان يجب عرض زر التحديث

**وظائف جديدة | New Methods:**
- `_compute_show_update_label()`: يحسب ما إذا كان يجب عرض زر التحديث
- `action_update_labels()`: يحدّث جميع أسماء البنود لتطابق المرجع
- `_update_journal_items_name()`: وظيفة مساعدة لنسخ المرجع إلى أسماء البنود

**المنطق | Logic:**
- يعمل فقط مع القيود (`move_type == 'entry'`)
- يتحقق من أن دفتر اليومية لديه `auto_fill_journal_item_name` مفعّل
- ينسخ `ref` إلى `name` في جميع `line_ids`

#### `account.journal` (Extended)

**حقول جديدة | New Fields:**
- `auto_fill_journal_item_name` (Boolean): خيار تفعيل النسخ التلقائي

#### `res.company` (Extended)

**حقول جديدة | New Fields:**
- `auto_fill_journal_item_name` (Boolean): خيار تفعيل النسخ التلقائي على مستوى الشركة

---

## 🔍 استكشاف الأخطاء | Troubleshooting

### المشكلة: المرجع لا ينسخ تلقائياً
**الأسباب المحتملة | Possible Causes:**
- الميزة غير مفعّلة في دفتر اليومية
- القيد ليس من نوع "Journal Entry"
- المرجع فارغ

**الحلول | Solutions:**
1. تحقق من أن "Auto-fill Journal Item Names" مفعّل في دفتر اليومية
2. تأكد من أن نوع القيد هو "Journal Entry"
3. تأكد من إدخال قيمة في حقل المرجع

### المشكلة: زر "Update Labels" لا يظهر
**الأسباب المحتملة | Possible Causes:**
- أسماء البنود تطابق المرجع بالفعل
- الميزة غير مفعّلة
- القيد ليس من نوع "Journal Entry"

**الحلول | Solutions:**
1. تحقق من أن أسماء البنود مختلفة عن المرجع
2. تحقق من تفعيل الميزة في دفتر اليومية
3. تأكد من نوع القيد

### المشكلة: الميزة لا تعمل في الفواتير
**الحل | Solution:**
هذا السلوك متوقع. الميزة تعمل فقط مع القيود (Journal Entries) وليس مع الفواتير أو الفواتير المستحقة.

---

## 📊 أفضل الممارسات | Best Practices

### 1. التكوين
- فعّل الميزة فقط في دفاتر اليومية التي تحتاجها
- استخدم التكوين على مستوى الشركة للاتساق عبر جميع دفاتر اليومية
- راجع الإعدادات بانتظام

### 2. الاستخدام
- استخدم أوصاف واضحة في حقل المرجع
- راجع القيود بعد الإنشاء للتأكد من صحة الأسماء
- استخدم زر "Update Labels" عند الحاجة

### 3. الصيانة
- راجع القيود بانتظام للتأكد من الاتساق
- حافظ على أوصاف واضحة ومفيدة
- وثّق أي استثناءات أو حالات خاصة

---

## 🔄 تاريخ الإصدارات | Version History

### Version 19.0.1.0.0
- الإصدار الأولي لـ Odoo 19
- النسخ التلقائي للمرجع إلى أسماء البنود
- التكوين على مستوى دفتر اليومية
- التكوين على مستوى الشركة
- زر تحديث تلقائي
- واجهة مستخدم محسّنة

---

## 📞 الدعم والاتصال | Support & Contact

### الحصول على المساعدة | Get Help

- **الموقع الإلكتروني**: [https://solidsups.com](https://solidsups.com)
- **البريد الإلكتروني**: info@solidsups.com
- **LinkedIn**: [Solid Super Solutions](https://www.linkedin.com/company/109981576)

### الإبلاغ عن الأخطاء | Bug Reports

يرجى الإبلاغ عن الأخطاء أو طلبات الميزات من خلال:
- البريد الإلكتروني: info@solidsups.com
- يرجى تضمين إصدار الموديول وإصدار Odoo في تقريرك

---

## 📄 الترخيص | License

هذا الموديول مرخص تحت **LGPL-3**.

This module is licensed under **LGPL-3**.

---

<div align="center">

**تم التطوير بواسطة [Solid Super Solutions](https://solidsups.com)**

**Developed with ❤️ by [Solid Super Solutions](https://solidsups.com)**

*تبسيط إدخال القيود المحاسبية في Odoo*

*Simplifying journal entry input in Odoo*

</div>
