# Contact Approval Module

<div align="center">

**Manage contacts through an approval workflow in Odoo 19**

[![License](https://img.shields.io/badge/license-LGPL--3-blue.svg)](LICENSE)
[![Version](https://img.shields.io/badge/version-19.0.1.0.0-green.svg)](__manifest__.py)
[![Odoo](https://img.shields.io/badge/odoo-19.0-blue.svg)](https://www.odoo.com)

</div>

---

## 📋 Overview

The **Contact Approval** module provides a comprehensive workflow management system for contacts in Odoo. It ensures that only approved contacts can be used across critical business operations including sales, purchases, inventory, and invoicing. This module enhances data quality and security by implementing a mandatory approval process for all new contacts.

## ✨ Key Features

### 🔐 Approval Workflow
- **Three-State System**: Draft → Approved → Cancelled
- **Status Management**: Clear visual indicators for contact approval status
- **Workflow Control**: Only approved contacts can be used in business transactions

### 🔗 Seamless Integration
Works seamlessly with:
- **Sales Orders** - Only approved contacts can be selected as customers
- **Purchase Orders** - Only approved vendors can be selected
- **Stock Pickings** - Only approved contacts in delivery operations
- **Account Moves** - Only approved contacts in invoices and bills
- **CRM Leads** - Only approved contacts in lead management

### 👥 Security & Access Control
- **Role-Based Permissions**: Dedicated "Contacts Approval Manager" group
- **Selective Access**: Only authorized users can approve/cancel contacts
- **Domain Restrictions**: Automatic filtering of non-approved contacts

### 📊 User Experience
- **Visual Status Indicators**: Clear status badges in contact forms
- **Smart Filtering**: Automatic domain restrictions in selection lists
- **Intuitive Interface**: Easy-to-use approval controls

## 🚀 Installation

### Prerequisites
- Odoo 19.0 or later
- Required dependencies:
  - `contacts`
  - `sale_management`
  - `purchase`
  - `stock`
  - `account`

### Installation Steps

1. **Copy the module** to your Odoo addons directory:
   ```bash
   cp -r sss_contact_approval /path/to/odoo/addons/
   ```

2. **Update the app list** in Odoo:
   - Navigate to **Apps** menu
   - Click **Update Apps List**

3. **Install the module**:
   - Search for "Contact Approval"
   - Click **Install**

## 📖 Usage Guide

### Basic Workflow

#### 1. Creating a New Contact

When you create a new contact:
- The contact is automatically set to **"Draft"** status
- The contact cannot be used in sales, purchases, or invoices until approved

#### 2. Approving a Contact

**Prerequisites**: User must be a member of "Contacts Approval Manager" group

**Steps**:
1. Navigate to **Contacts** menu
2. Open the contact you want to approve
3. Click the **"Approve"** button in the form view
4. The contact status changes to **"Approved"**
5. The contact can now be used in all business operations

#### 3. Using Approved Contacts

Once approved, contacts can be selected in:
- **Sales Orders**: Customer field shows only approved contacts
- **Purchase Orders**: Vendor field shows only approved contacts
- **Stock Pickings**: Partner field shows only approved contacts
- **Invoices/Bills**: Partner field shows only approved contacts
- **CRM Leads**: Partner field shows only approved contacts

### Advanced Operations

#### Cancelling a Contact

If a contact needs to be deactivated:
1. Open the contact form
2. Click **"Cancel"** button
3. The contact status changes to **"Cancelled"**
4. The contact is removed from all selection lists

#### Resetting Contact Status

To reset a cancelled contact back to draft:
1. Open the cancelled contact
2. Click **"Reset to Draft"** button
3. The contact returns to draft status for re-approval

## 🔒 Security Configuration

### Setting Up Approval Managers

1. Navigate to **Settings > Users & Companies > Groups**
2. Find **"Contacts Approval Manager"** group
3. Add users who should have approval permissions
4. Save changes

### Access Rights

- **Regular Users**: Can create contacts but cannot approve them
- **Approval Managers**: Can approve, cancel, and reset contacts
- **System Administrators**: Full access to all operations

## 🎯 Use Cases

### Scenario 1: New Customer Onboarding
1. Sales team creates a new customer contact
2. Contact is in "Draft" status
3. Approval manager reviews customer information
4. Manager approves the contact
5. Sales team can now create sales orders for this customer

### Scenario 2: Vendor Verification
1. Procurement team adds a new vendor
2. Vendor contact is in "Draft" status
3. Finance team verifies vendor credentials
4. Finance team approves the vendor
5. Procurement can now create purchase orders

### Scenario 3: Data Quality Control
1. All new contacts require approval
2. Prevents use of incomplete or incorrect contact data
3. Ensures data quality across all business operations
4. Maintains clean and accurate contact database

## 🛠️ Technical Details

### Module Structure

```
sss_contact_approval/
├── models/
│   ├── res_partner.py          # Contact model with approval workflow
│   ├── sale_order.py           # Sales order domain restrictions
│   ├── purchase_order.py       # Purchase order domain restrictions
│   ├── stock_picking.py        # Stock picking domain restrictions
│   ├── account_move.py         # Invoice domain restrictions
│   └── crm_lead.py             # CRM lead domain restrictions
├── views/
│   ├── res_partner_views.xml   # Contact form and list views
│   ├── sale_order_views.xml    # Sales order view modifications
│   ├── purchase_order_views.xml # Purchase order view modifications
│   ├── stock_picking_views.xml  # Stock picking view modifications
│   ├── account_move_views.xml   # Invoice view modifications
│   └── crm_lead_views.xml      # CRM lead view modifications
├── security/
│   └── sss_contact_approval_groups.xml # Security groups
└── static/
    └── description/
        └── sss_contact_approval_icon.png
```

### Model Extensions

#### `res.partner` (Extended)

**New Fields**:
- `approval_status` (Selection): Draft, Approved, Cancelled
- `approved_by` (Many2one): User who approved the contact
- `approved_date` (Datetime): Date and time of approval

**New Methods**:
- `action_approve()`: Approve the contact
- `action_cancel()`: Cancel the contact
- `action_reset_to_draft()`: Reset to draft status

**Domain Restrictions**:
- Automatic filtering in related models to show only approved contacts

### Integration Points

The module extends the following Odoo models:
- `sale.order` - Customer field domain
- `purchase.order` - Vendor field domain
- `stock.picking` - Partner field domain
- `account.move` - Partner field domain
- `crm.lead` - Partner field domain

## 📝 Configuration Examples

### Example 1: Approving a Customer

```python
# Contact is created with status = 'draft'
contact = self.env['res.partner'].create({
    'name': 'New Customer',
    'is_company': True,
    'customer_rank': 1,
})

# Approval manager approves the contact
contact.action_approve()
# Status changes to 'approved'
# Contact can now be used in sales orders
```

### Example 2: Domain Filter in Sales Order

```python
# Only approved contacts appear in customer selection
domain = [('approval_status', '=', 'approved')]
```

## 🔍 Troubleshooting

### Issue: Contact Cannot Be Approved

**Possible Causes**:
- User is not a member of "Contacts Approval Manager" group
- Contact is already approved or cancelled
- Missing access rights

**Solutions**:
1. Verify user group membership
2. Check contact current status
3. Verify access rights in Settings

### Issue: Approved Contact Not Appearing in Selection

**Possible Causes**:
- Contact was cancelled after approval
- Domain filter not applied correctly
- Cache issues

**Solutions**:
1. Check contact approval status
2. Verify domain filters in related models
3. Clear browser cache and refresh

### Issue: Cannot Create Sales Order with New Contact

**Solution**:
This is expected behavior. New contacts must be approved before use:
1. Create the contact
2. Have an approval manager approve it
3. Then use it in sales orders

## 📊 Best Practices

### 1. Approval Workflow
- Establish clear approval criteria
- Train approval managers on the process
- Set up approval notifications (if needed)

### 2. Contact Management
- Review draft contacts regularly
- Approve contacts promptly to avoid delays
- Cancel obsolete contacts to maintain data quality

### 3. Security
- Limit approval manager group membership
- Regularly audit approval activities
- Document approval procedures

### 4. Data Quality
- Verify contact information before approval
- Maintain accurate contact data
- Regular cleanup of cancelled contacts

## 🔄 Version History

### Version 19.0.1.0.0
- Initial release for Odoo 19
- Three-state approval workflow (Draft/Approved/Cancelled)
- Integration with Sales, Purchase, Stock, Account, and CRM
- Role-based security with approval manager group
- Automatic domain restrictions in related models

## 📞 Support & Contact

### Get Help

- **Website**: [https://solidsups.com](https://solidsups.com)
- **Email**: info@solidsups.com
- **LinkedIn**: [Solid Super Solutions](https://www.linkedin.com/company/109981576)

### Bug Reports

Please report bugs or feature requests through:
- Email: info@solidsups.com
- Include module version and Odoo version in your report

## 📄 License

This module is licensed under **LGPL-3**.

---

<div align="center">

**Developed with ❤️ by [Solid Super Solutions](https://solidsups.com)**

*Enhancing Odoo functionality for businesses worldwide*

</div>
