# -*- coding: utf-8 -*-
# All Copyrights Reserved to Solid Super Solutions
from odoo import fields, models


class PurchaseOrder(models.Model):
    """
        Customization of Purchase Order model to add additional features.
        """
    _inherit = 'purchase.order'

    READONLY_STATES = {
        'purchase': [('readonly', True)],
        'done': [('readonly', True)],
        'cancel': [('readonly', True)],
    }
    partner_id = fields.Many2one(
        'res.partner', string='Vendor', required=True,
        states=READONLY_STATES, change_default=True,
        track_visibility='onchange', help="Select the customer from the list of approved customers.",
        domain="['|', ('company_id', '=', False), ('company_id', '=', company_id), ('state', '=', 'approve')]")
