# Contact Approval Module (Odoo 19)

<div align="center">

**نظام الموافقة على جهات الاتصال في Odoo 19**

[![License](https://img.shields.io/badge/license-LGPL--3-blue.svg)](LICENSE)
[![Version](https://img.shields.io/badge/version-19.0.1.0.0-green.svg)](__manifest__.py)
[![Odoo](https://img.shields.io/badge/odoo-19.0-blue.svg)](https://www.odoo.com)

</div>

---

## 📋 نظرة عامة | Overview

موديول **الموافقة على جهات الاتصال** يوفر نظام إدارة شامل لجهات الاتصال في Odoo. يضمن أن جهات الاتصال المعتمدة فقط يمكن استخدامها في العمليات التجارية الحرجة بما في ذلك المبيعات والمشتريات والمخزون والفواتير. يعزز هذا الموديول جودة البيانات والأمان من خلال تطبيق عملية موافقة إلزامية لجميع جهات الاتصال الجديدة.

The **Contact Approval** module provides a comprehensive workflow management system for contacts in Odoo. It ensures that only approved contacts can be used across critical business operations including sales, purchases, inventory, and invoicing. This module enhances data quality and security by implementing a mandatory approval process for all new contacts.

---

## ✨ المميزات الرئيسية | Key Features

### 🔐 نظام الموافقة | Approval Workflow
- **نظام ثلاثي الحالات**: مسودة → معتمد → ملغى
- **إدارة الحالة**: مؤشرات بصرية واضحة لحالة موافقة جهة الاتصال
- **التحكم في سير العمل**: يمكن استخدام جهات الاتصال المعتمدة فقط في المعاملات التجارية

- **Three-State System**: Draft → Approved → Cancelled
- **Status Management**: Clear visual indicators for contact approval status
- **Workflow Control**: Only approved contacts can be used in business transactions

### 🔗 التكامل السلس | Seamless Integration
يعمل بشكل سلس مع:
- **أوامر البيع**: يمكن اختيار العملاء المعتمدين فقط
- **أوامر الشراء**: يمكن اختيار الموردين المعتمدين فقط
- **نقل المخزون**: جهات الاتصال المعتمدة فقط في عمليات التسليم
- **القيود المحاسبية**: جهات الاتصال المعتمدة فقط في الفواتير والفواتير المستحقة
- **إدارة العملاء المحتملين**: جهات الاتصال المعتمدة فقط في إدارة العملاء المحتملين

Works seamlessly with:
- **Sales Orders** - Only approved contacts can be selected as customers
- **Purchase Orders** - Only approved vendors can be selected
- **Stock Pickings** - Only approved contacts in delivery operations
- **Account Moves** - Only approved contacts in invoices and bills
- **CRM Leads** - Only approved contacts in lead management

### 👥 الأمان والتحكم في الوصول | Security & Access Control
- **الصلاحيات القائمة على الأدوار**: مجموعة مخصصة "مدير موافقة جهات الاتصال"
- **الوصول الانتقائي**: المستخدمون المصرح لهم فقط يمكنهم الموافقة/إلغاء جهات الاتصال
- **قيود النطاق**: تصفية تلقائية لجهات الاتصال غير المعتمدة

- **Role-Based Permissions**: Dedicated "Contacts Approval Manager" group
- **Selective Access**: Only authorized users can approve/cancel contacts
- **Domain Restrictions**: Automatic filtering of non-approved contacts

### 📊 تجربة المستخدم | User Experience
- **مؤشرات الحالة البصرية**: شارات حالة واضحة في نماذج جهات الاتصال
- **التصفية الذكية**: قيود النطاق التلقائية في قوائم الاختيار
- **واجهة سهلة الاستخدام**: عناصر تحكم سهلة الاستخدام للموافقة

- **Visual Status Indicators**: Clear status badges in contact forms
- **Smart Filtering**: Automatic domain restrictions in selection lists
- **Intuitive Interface**: Easy-to-use approval controls

---

## 🚀 التثبيت | Installation

### المتطلبات | Prerequisites
- Odoo 19.0 أو أحدث
- المتطلبات التالية:
  - `contacts`
  - `sale_management`
  - `purchase`
  - `stock`
  - `account`

- Odoo 19.0 or later
- Required dependencies:
  - `contacts`
  - `sale_management`
  - `purchase`
  - `stock`
  - `account`

### خطوات التثبيت | Installation Steps

1. **انسخ الموديول** إلى مجلد الإضافات:
   ```bash
   cp -r sss_contact_approval /path/to/odoo/addons/
   ```

2. **حدّث قائمة التطبيقات** في Odoo:
   - اذهب إلى قائمة **Apps**
   - اضغط **Update Apps List**

3. **ثبّت الموديول**:
   - ابحث عن "Contact Approval"
   - اضغط **Install**

---

## 📖 دليل الاستخدام | Usage Guide

### سير العمل الأساسي | Basic Workflow

#### 1. إنشاء جهة اتصال جديدة | Creating a New Contact

عند إنشاء جهة اتصال جديدة:
- يتم تعيين جهة الاتصال تلقائياً إلى حالة **"مسودة"**
- لا يمكن استخدام جهة الاتصال في المبيعات أو المشتريات أو الفواتير حتى يتم اعتمادها

When you create a new contact:
- The contact is automatically set to **"Draft"** status
- The contact cannot be used in sales, purchases, or invoices until approved

#### 2. اعتماد جهة اتصال | Approving a Contact

**المتطلبات المسبقة | Prerequisites**: يجب أن يكون المستخدم عضواً في مجموعة "مدير موافقة جهات الاتصال"

**الخطوات | Steps:**
1. اذهب إلى قائمة **جهات الاتصال**
2. افتح جهة الاتصال التي تريد اعتمادها
3. اضغط زر **"Approve"** في نموذج جهة الاتصال
4. تتغير حالة جهة الاتصال إلى **"معتمد"**
5. يمكن الآن استخدام جهة الاتصال في جميع العمليات التجارية

#### 3. استخدام جهات الاتصال المعتمدة | Using Approved Contacts

بعد الاعتماد، يمكن اختيار جهات الاتصال في:
- **أوامر البيع**: حقل العميل يعرض فقط جهات الاتصال المعتمدة
- **أوامر الشراء**: حقل المورد يعرض فقط جهات الاتصال المعتمدة
- **نقل المخزون**: حقل الشريك يعرض فقط جهات الاتصال المعتمدة
- **الفواتير/الفواتير المستحقة**: حقل الشريك يعرض فقط جهات الاتصال المعتمدة
- **العملاء المحتملين**: حقل الشريك يعرض فقط جهات الاتصال المعتمدة

### العمليات المتقدمة | Advanced Operations

#### إلغاء جهة اتصال | Cancelling a Contact

إذا كانت جهة اتصال بحاجة إلى إلغاء تفعيلها:
1. افتح نموذج جهة الاتصال
2. اضغط زر **"Cancel"**
3. تتغير حالة جهة الاتصال إلى **"ملغى"**
4. يتم إزالة جهة الاتصال من جميع قوائم الاختيار

#### إعادة تعيين حالة جهة الاتصال | Resetting Contact Status

لإعادة تعيين جهة اتصال ملغاة إلى مسودة:
1. افتح جهة الاتصال الملغاة
2. اضغط زر **"Reset"**
3. تعود جهة الاتصال إلى حالة مسودة لإعادة الاعتماد

---

## 🔒 إعدادات الأمان | Security Configuration

### إعداد مديري الموافقة | Setting Up Approval Managers

1. اذهب إلى **الإعدادات > المستخدمون والشركات > المجموعات**
2. ابحث عن مجموعة **"مدير موافقة جهات الاتصال"**
3. أضف المستخدمين الذين يجب أن تكون لديهم صلاحيات الموافقة
4. احفظ التغييرات

### حقوق الوصول | Access Rights

- **المستخدمون العاديون**: يمكنهم إنشاء جهات الاتصال ولكن لا يمكنهم اعتمادها
- **مديرو الموافقة**: يمكنهم اعتماد وإلغاء وإعادة تعيين جهات الاتصال
- **مسؤولو النظام**: وصول كامل لجميع العمليات

---

## 🎯 حالات الاستخدام | Use Cases

### السيناريو 1: إعداد عميل جديد
1. فريق المبيعات ينشئ جهة اتصال عميل جديد
2. جهة الاتصال في حالة "مسودة"
3. مدير الموافقة يراجع معلومات العميل
4. المدير يعتمد جهة الاتصال
5. يمكن لفريق المبيعات الآن إنشاء أوامر بيع لهذا العميل

### السيناريو 2: التحقق من المورد
1. فريق المشتريات يضيف مورداً جديداً
2. جهة اتصال المورد في حالة "مسودة"
3. فريق المالية يتحقق من بيانات اعتماد المورد
4. فريق المالية يعتمد المورد
5. يمكن للمشتريات الآن إنشاء أوامر شراء

### السيناريو 3: التحكم في جودة البيانات
1. جميع جهات الاتصال الجديدة تتطلب الموافقة
2. يمنع استخدام بيانات جهات الاتصال غير المكتملة أو غير الصحيحة
3. يضمن جودة البيانات عبر جميع العمليات التجارية
4. يحافظ على قاعدة بيانات جهات اتصال نظيفة ودقيقة

---

## 🛠️ التفاصيل التقنية | Technical Details

### هيكل الموديول | Module Structure

```
sss_contact_approval/
├── models/
│   ├── res_partner.py          # نموذج جهة الاتصال مع سير عمل الموافقة
│   ├── sale_order.py           # قيود النطاق في أوامر البيع
│   ├── purchase_order.py       # قيود النطاق في أوامر الشراء
│   ├── stock_picking.py        # قيود النطاق في نقل المخزون
│   ├── account_move.py         # قيود النطاق في الفواتير
│   └── crm_lead.py             # قيود النطاق في العملاء المحتملين
├── views/
│   ├── res_partner_views.xml   # نماذج وقوائم جهات الاتصال
│   ├── sale_order_views.xml    # تعديلات عرض أمر البيع
│   ├── purchase_order_views.xml # تعديلات عرض أمر الشراء
│   ├── stock_picking_views.xml  # تعديلات عرض نقل المخزون
│   ├── account_move_views.xml   # تعديلات عرض الفاتورة
│   └── crm_lead_views.xml      # تعديلات عرض العميل المحتمل
├── security/
│   └── sss_contact_approval_groups.xml # مجموعات الأمان
└── static/
    └── description/
        └── sss_contact_approval_icon.png
```

### التوسعات على النموذج | Model Extensions

#### `res.partner` (Extended)

**حقول جديدة | New Fields:**
- `state` (Selection): مسودة، معتمد، ملغى
- `approver_id` (Many2one): المستخدم الذي اعتمد جهة الاتصال

**وظائف جديدة | New Methods:**
- `action_approve_contact()`: اعتماد جهة الاتصال
- `action_cancel_contact()`: إلغاء جهة الاتصال
- `action_reset_contact()`: إعادة تعيين إلى مسودة
- `action_view_sale_order()`: منع استخدام جهات الاتصال غير المعتمدة
- `action_view_opportunity()`: منع استخدام جهات الاتصال غير المعتمدة في العملاء المحتملين

**قيود النطاق | Domain Restrictions:**
- تصفية تلقائية في النماذج ذات الصلة لإظهار جهات الاتصال المعتمدة فقط

### نقاط التكامل | Integration Points

الموديول يوسع النماذج التالية في Odoo:
- `sale.order` - نطاق حقل العميل
- `purchase.order` - نطاق حقل المورد
- `stock.picking` - نطاق حقل الشريك
- `account.move` - نطاق حقل الشريك
- `crm.lead` - نطاق حقل الشريك

---

## 🔍 استكشاف الأخطاء | Troubleshooting

### المشكلة: لا يمكن اعتماد جهة اتصال
**الأسباب المحتملة | Possible Causes:**
- المستخدم ليس عضواً في مجموعة "مدير موافقة جهات الاتصال"
- جهة الاتصال معتمدة أو ملغاة بالفعل
- حقوق الوصول مفقودة

**الحلول | Solutions:**
1. تحقق من عضوية المستخدم في المجموعة
2. تحقق من الحالة الحالية لجهة الاتصال
3. تحقق من حقوق الوصول في الإعدادات

### المشكلة: جهة اتصال معتمدة لا تظهر في الاختيار
**الأسباب المحتملة | Possible Causes:**
- تم إلغاء جهة الاتصال بعد الاعتماد
- قيد النطاق لم يتم تطبيقه بشكل صحيح
- مشاكل في التخزين المؤقت

**الحلول | Solutions:**
1. تحقق من حالة موافقة جهة الاتصال
2. تحقق من قيود النطاق في النماذج ذات الصلة
3. امسح التخزين المؤقت للمتصفح وحدّث

### المشكلة: لا يمكن إنشاء أمر بيع مع جهة اتصال جديدة
**الحل | Solution:**
هذا السلوك متوقع. يجب اعتماد جهات الاتصال الجديدة قبل الاستخدام:
1. أنشئ جهة الاتصال
2. اطلب من مدير الموافقة اعتمادها
3. ثم استخدمها في أوامر البيع

---

## 📊 أفضل الممارسات | Best Practices

### 1. سير عمل الموافقة
- حدد معايير موافقة واضحة
- درّب مديري الموافقة على العملية
- أعد إعداد إشعارات الموافقة (إذا لزم الأمر)

### 2. إدارة جهات الاتصال
- راجع جهات الاتصال المسودة بانتظام
- اعتمد جهات الاتصال بسرعة لتجنب التأخيرات
- ألغِ جهات الاتصال القديمة للحفاظ على جودة البيانات

### 3. الأمان
- قلل عضوية مجموعة مدير الموافقة
- راجع أنشطة الموافقة بانتظام
- وثّق إجراءات الموافقة

### 4. جودة البيانات
- تحقق من معلومات جهة الاتصال قبل الاعتماد
- حافظ على بيانات جهات الاتصال دقيقة
- تنظيف منتظم لجهات الاتصال الملغاة

---

## 🔄 تاريخ الإصدارات | Version History

### Version 19.0.1.0.0
- الإصدار الأولي لـ Odoo 19
- سير عمل الموافقة ثلاثي الحالات (مسودة/معتمد/ملغى)
- التكامل مع المبيعات والمشتريات والمخزون والحسابات والعملاء المحتملين
- الأمان القائم على الأدوار مع مجموعة مدير الموافقة
- قيود النطاق التلقائية في النماذج ذات الصلة

---

## 📞 الدعم والاتصال | Support & Contact

### الحصول على المساعدة | Get Help

- **الموقع الإلكتروني**: [https://solidsups.com](https://solidsups.com)
- **البريد الإلكتروني**: info@solidsups.com
- **LinkedIn**: [Solid Super Solutions](https://www.linkedin.com/company/109981576)

### الإبلاغ عن الأخطاء | Bug Reports

يرجى الإبلاغ عن الأخطاء أو طلبات الميزات من خلال:
- البريد الإلكتروني: info@solidsups.com
- يرجى تضمين إصدار الموديول وإصدار Odoo في تقريرك

---

## 📄 الترخيص | License

هذا الموديول مرخص تحت **LGPL-3**.

This module is licensed under **LGPL-3**.

---

<div align="center">

**تم التطوير بواسطة [Solid Super Solutions](https://solidsups.com)**

**Developed with ❤️ by [Solid Super Solutions](https://solidsups.com)**

*تحسين إدارة جهات الاتصال في Odoo*

*Enhancing contact management in Odoo*

</div>
