# -*- coding: utf-8 -*-
# All Copyrights Reserved to Solid Super Solutions
from odoo import fields, models, api

class CrmLead(models.Model):
    """
    Inherited the CRM Lead model to add additional features.
    """
    _inherit = 'crm.lead'

    partner_id = fields.Many2one(
        'res.partner', string='Customer', index=True, tracking=10,
        domain="[('type', '!=', 'private'), ('company_id', 'in', (False, company_id)), ('state', '=', 'approve')]",
        help="Select the customer from the list of approved customers.")

    @api.model
    def create(self, vals_list):
        """Override create to ensure only approved contacts can be set"""
        # Handle both single dict and list of dicts (batch creation in Odoo 19)
        if not isinstance(vals_list, list):
            vals_list = [vals_list]
        
        # Process each dictionary in the list
        for vals in vals_list:
            # Check partner_id
            if vals.get('partner_id'):
                partner = self.env['res.partner'].browse(vals['partner_id'])
                if partner.state != 'approve':
                    vals['partner_id'] = False
        
        return super(CrmLead, self).create(vals_list)

    @api.onchange('partner_id')
    def _onchange_partner_id(self):
        """Ensure only approved contacts can be set"""
        if self.partner_id and self.partner_id.state != 'approve':
            self.partner_id = False
