# -*- coding: utf-8 -*-
# All Copyrights Reserved to Solid Super Solutions
from odoo import fields, models


class SaleOrder(models.Model):
    """
           Inherited the Sale Order model to add additional features.
            """
    _inherit = 'sale.order'

    partner_id = fields.Many2one(
        'res.partner', string='Customer', readonly=True,
        states={'draft': [('readonly', False)], 'sent': [('readonly', False)]},
        required=True, change_default=True, index=True, tracking=1,
        help="Select the customer from the list of approved customers.",
        domain="[('type', '!=', 'private'), ('company_id', 'in', (False, company_id)), ('state', '=', 'approve')]")
