# -*- coding: utf-8 -*-
# All Copyrights Reserved to Solid Super Solutions
from odoo import fields, models


class StockPicking(models.Model):
    """
        Inherited the Stock Picking model to add additional features.
        """
    _inherit = 'stock.picking'

    partner_id = fields.Many2one(
        'res.partner', 'Contact',
        check_company=True, domain="[('state', '=', 'approve')]",
        states={'done': [('readonly', True)], 'cancel': [('readonly', True)]},
        help='Select the customer from the list of approved customers.')
