from odoo import models, fields

class JournalReportHistory(models.Model):
    _name = 'journal.report.history'
    _description = 'Journal Report Generation History'
    _order = 'create_date desc'

    move_id = fields.Many2one('account.move', string='Journal Entry', required=True)
    user_id = fields.Many2one('res.users', string='Generated By', default=lambda self: self.env.user)
    create_date = fields.Datetime('Generation Date', readonly=True)
    company_id = fields.Many2one('res.company', related='move_id.company_id', store=True) 