from odoo import models, fields, api

class JournalReportSettings(models.Model):
    _name = 'journal.report.settings'
    _description = 'Journal Report Settings'

    company_id = fields.Many2one('res.company', string='Company', required=True, default=lambda self: self.env.company)
    show_logo = fields.Boolean('Show Company Logo', default=True)
    show_tagline = fields.Boolean('Show Company Tagline', default=True)
    tagline = fields.Char('Custom Tagline')
    footer_text = fields.Text('Custom Footer Text')
    
    @api.model
    def get_settings(self, company_id=None):
        if not company_id:
            company_id = self.env.company.id
        settings = self.search([('company_id', '=', company_id)], limit=1)
        if not settings:
            settings = self.create({'company_id': company_id})
        return settings 