# SSS Journal Entry Report

## Overview

**SSS Journal Entry Report** is a comprehensive accounting module that provides a professional, customizable journal entry report with company branding, detailed analytics, and multi-language support.

## Features

### 🎯 Core Features

- **Custom Journal Entry Reports**: Generate professional journal entry reports with company branding
- **Company Logo & Information**: Automatically includes company logo and details in reports
- **Customizable Header & Footer**: Add custom taglines and footer text
- **Analytic Distribution Display**: Shows analytic account distribution with percentages
- **Multi-Currency Support**: Handles multiple currencies in journal entries
- **Bilingual Support**: Full support for English and Arabic languages
- **Report History Tracking**: Track all generated reports for audit purposes

### 📊 Report Features

- Detailed journal entry information
- Line-by-line breakdown with analytics
- Company branding and customization
- Professional formatting
- Print-ready PDF output

## Installation

### Requirements

- Odoo 19.0
- Dependencies:
  - `base`
  - `account`
  - `web`
  - `analytic`

### Installation Steps

1. **Copy the module** to your Odoo addons directory:
   ```bash
   cp -r sss_simple_journal_report /path/to/odoo/addons/
   ```

2. **Update the app list** in Odoo:
   - Go to **Apps** menu
   - Click **Update Apps List**

3. **Install the module**:
   - Search for "SSS Journal Entry Report"
   - Click **Install**

## Configuration

### 1. Report Settings

Navigate to: **Accounting > Configuration > Journal Report Settings**

#### Settings Options:

- **Company**: Select the company for these settings
- **Show Company Logo**: Toggle to show/hide company logo in reports
- **Show Company Tagline**: Toggle to show/hide company tagline
- **Custom Tagline**: Enter a custom tagline to display in reports
- **Custom Footer Text**: Add custom text to appear in the report footer

#### Example Configuration:

```
Company: Your Company Name
Show Company Logo: ✓ Enabled
Show Company Tagline: ✓ Enabled
Custom Tagline: "Excellence in Accounting"
Custom Footer Text: "This report is generated automatically. For inquiries, contact accounting@solidsups.com"
```

### 2. Company Logo Setup

Ensure your company has a logo configured:
- Go to **Settings > Companies > Your Company**
- Upload company logo in the **Logo** field

## Usage / Workflow

### Generating a Journal Entry Report

#### Method 1: From Journal Entry Form

1. Navigate to **Accounting > Journal Entries**
2. Open the journal entry you want to report
3. Click the **Print Journal Report** button (or use the **Print** menu)
4. The report will be generated in PDF format

#### Method 2: From Journal Entry List

1. Navigate to **Accounting > Journal Entries**
2. Select one or more journal entries
3. Click **Print** > **Journal Entry Report**
4. Review and download the generated report

### Report Contents

The generated report includes:

1. **Header Section**:
   - Company logo (if enabled)
   - Company name and details
   - Custom tagline (if enabled)
   - Report date and number

2. **Journal Entry Details**:
   - Entry number and date
   - Reference and description
   - Journal information

3. **Line Items**:
   - Account name
   - Debit and Credit amounts
   - Analytic distribution (if applicable)
   - Currency information

4. **Footer Section**:
   - Custom footer text (if configured)
   - Page numbers
   - Generation timestamp

### Analytic Distribution Display

When analytic accounts are assigned to journal entry lines:
- The report shows each analytic account with its percentage
- Format: `Account Name: XX%`
- Multiple accounts are displayed on separate lines

## Technical Details

### Module Structure

```
sss_simple_journal_report/
├── models/
│   ├── account_move.py          # Journal entry model extensions
│   ├── report_settings.py       # Report configuration model
│   └── report_history.py        # Report history tracking
├── views/
│   ├── account_move_views.xml   # Journal entry views
│   └── report_settings_views.xml # Settings views
├── reports/
│   └── journal_report.xml       # Report template
├── security/
│   └── ir.model.access.csv      # Access rights
└── static/
    ├── src/
    │   ├── fonts/               # Arabic font support
    │   └── scss/               # Custom styles
    └── description/
        └── icon.png             # Module icon
```

### Models

#### `journal.report.settings`
- Stores report configuration per company
- Fields: `company_id`, `show_logo`, `show_tagline`, `tagline`, `footer_text`

#### `account.move` (Extended)
- Added method: `print_journal_report()` - Generates the report

#### `account.move.line` (Extended)
- Added method: `get_formatted_analytic_distribution()` - Formats analytic accounts for display

### Access Rights

The module includes proper access rights:
- Users with accounting access can generate reports
- Settings are accessible to administrators

## Customization

### Customizing Report Template

The report template is located at:
```
reports/journal_report.xml
```

You can customize:
- Layout and structure
- Styling and formatting
- Additional fields
- Section ordering

### Customizing Styles

SCSS styles are located at:
```
static/src/scss/style.scss
```

Modify to change:
- Colors and fonts
- Spacing and margins
- Print-specific styles

## Troubleshooting

### Report Not Generating

**Issue**: Report button not appearing or report fails to generate

**Solutions**:
1. Check user has accounting access rights
2. Verify journal entry is posted (not draft)
3. Check Odoo logs for errors
4. Ensure all dependencies are installed

### Logo Not Showing

**Issue**: Company logo not appearing in report

**Solutions**:
1. Verify company logo is uploaded in Settings
2. Check "Show Company Logo" is enabled in report settings
3. Ensure logo file is valid image format (PNG, JPG, SVG)

### Arabic Text Not Displaying Correctly

**Issue**: Arabic characters appear incorrectly

**Solutions**:
1. Verify Arabic font file is present: `static/src/fonts/IBMPlexSansArabic-Regular.ttf`
2. Check browser/PDF viewer supports Arabic rendering
3. Ensure proper encoding in report template

## Support

### Contact Information

- **Website**: https://solidsups.com
- **Email**: info@solidsups.com
- **LinkedIn**: https://www.linkedin.com/company/109981576

### Bug Reports

Please report bugs or issues through:
- Odoo Apps support system
- Email: info@solidsups.com

## Version History

### Version 19.0.1.0.0
- Initial release for Odoo 19
- Journal entry report with company branding
- Analytic distribution support
- Multi-currency support
- Bilingual support (English/Arabic)

## License

LGPL-3

## Author

**Solid Super Solutions**

---

**Note**: This module requires Odoo 19.0 and the `account` module to function properly.
